/** @file   MMp3PlayerProvider.h
 * @brief   Declaration of MMp3PlayerProvider interface.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/07/13 16:26:45 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MMP3PLAYERPROVIDER_H
#define H_WWW_MMP3PLAYERPROVIDER_H

namespace WeWantWar {
  
/** @class  MMp3PlayerProvider
 * @brief   Interface to mp3 player.
 * @author  Tomi Lamminsaari
 *
 */
class MMp3PlayerProvider
{
public: // Constructors, destructor, operators
  virtual ~MMp3PlayerProvider() { }

  /** Sets the playback volume of the mp3-player.
   * @param   aNewVolume        The volume
   */
  virtual void setMp3Volume( int aNewVolume ) = 0;
  
  /** Changes the mp3 file being played.
   * @param   aSongIndex        Index of the song. -1 to stop playback.
   */
  virtual void playMp3File( int aSongIndex ) = 0;
  
  /** Returns the current playback volume.
   * @return  Volume
   */
  virtual int playbackVolume() const = 0;
};

};  // end of namespace

#endif
